/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.NslookupThread;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskResolvConfData;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CommandsUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskResolvConfIntegrity
extends Task {
    final String m_resolvConfLocation = "/etc/resolv.conf";
    final String m_domainLine = "^domain[\\s]+.*";
    final String m_domainField = "^domain[\\s]+";
    final String m_nameserverLine = "^nameserver[\\s]+.*";
    final String m_nameserverField = "^nameserver[\\s]+";
    final String m_searchOrderLine = "^search[\\s]+.*";
    final String m_searchOrderField = "^search[\\s]+";
    String m_timeoutDisplay = "options timeout";
    String m_retryDisplay = "options attempt";
    final String m_nslookup;
    Map<String, TaskResolvConfData> m_allNodeResolvConf = new HashMap<String, TaskResolvConfData>();
    List<String> m_confOKVector = new ArrayList<String>();
    boolean m_resolvConfMissingAllNodes = false;
    int m_maxNS = 3;
    long m_dnsAcceptableTime = 15000L;
    String m_localHost;

    public sTaskResolvConfIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.m_nslookup = new CommandsUtil().getNslookup();
    }

    @Override
    public boolean performTask() {
        try {
            if (this.m_localHost == null) {
                this.m_localHost = VerificationUtil.getLocalHost();
            }
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: while getting local node" + uhe));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String msg = s_msgBundle.getMessage("0002", true);
            ReportUtil.printError(msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        boolean status = true;
        if (!this.prepareNodeResolvConfMap()) {
            return false;
        }
        if (this.m_resolvConfMissingAllNodes) {
            return true;
        }
        if (this.m_confOKVector.size() > 0) {
            if (!this.performSearchAndDomainCheck()) {
                status = false;
            }
            if (!this.performDomainFieldValidation()) {
                status = false;
            }
            if (!this.performSearchOrderValidation()) {
                status = false;
            }
            if (!this.performTimeOutRetryAttempsValidation()) {
                status = false;
            }
        }
        return status;
    }

    public boolean performDomainFieldValidation() {
        ErrorDescription errDesc;
        ResultSet locRes = new ResultSet();
        boolean toRejectAllConfigFiles = false;
        boolean status = true;
        ReportUtil.println(s_msgBundle.getMessage("5601", false, (Object[])new String[]{"/etc/resolv.conf"}));
        ArrayList<String> domainExistNode = new ArrayList<String>();
        ArrayList<String> domainNonExistantNodes = new ArrayList<String>();
        for (String node : this.m_confOKVector) {
            if (this.m_allNodeResolvConf.get(node).isDomainDefined()) {
                Trace.out((String)("domain exists on node :" + node));
                domainExistNode.add(node);
                continue;
            }
            Trace.out((String)("domain does not exist on node :" + node));
            domainNonExistantNodes.add(node);
        }
        if (domainExistNode.size() > 0 && domainNonExistantNodes.size() > 0) {
            String[] domainNonExistantArray = domainNonExistantNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5603", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(domainNonExistantNodes)});
            locRes.addResult(domainNonExistantArray, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            if (domainExistNode.size() == 0) {
                ReportUtil.println(s_gMsgBundle.getMessage("2010", false, (Object[])new String[]{"/etc/resolv.conf"}));
            }
            locRes.addResult(this.m_confOKVector.toArray(new String[0]), 1);
        }
        if (domainExistNode.size() == 0) {
            Trace.out((String)"domain name doesn't exist on any node");
            this.m_resultSet.uploadResultSet(locRes);
            return status;
        }
        ArrayList<String> singleDomainNodes = new ArrayList<String>();
        ArrayList<String> multiDomainNodes = new ArrayList<String>();
        ReportUtil.println(s_msgBundle.getMessage("5625", false, (Object[])new String[]{"/etc/resolv.conf"}));
        for (String node : domainExistNode) {
            int domainCount = this.m_allNodeResolvConf.get(node).getDomainCount();
            Trace.out((String)("There are " + domainCount + " domains on " + node));
            if (domainCount > 1) {
                multiDomainNodes.add(node);
                continue;
            }
            locRes.addResult(node, 1);
            singleDomainNodes.add(node);
        }
        if (multiDomainNodes.size() > 0) {
            toRejectAllConfigFiles = true;
            String[] multiDomainArray = multiDomainNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5609", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(multiDomainNodes)});
            locRes.addResult(multiDomainArray, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            ReportUtil.println(s_gMsgBundle.getMessage("2015", false, (Object[])new String[]{"/etc/resolv.conf"}));
        }
        if (singleDomainNodes.size() <= 1) {
            Trace.out((String)"no or only one nodes with single domain name");
            this.m_resultSet.uploadResultSet(locRes);
            return status;
        }
        Hashtable<Object, Vector<Object>> domainTable = new Hashtable<Object, Vector<Object>>();
        for (String node : singleDomainNodes) {
            VerificationUtil.updateResultMap(domainTable, this.m_allNodeResolvConf.get(node).getDomainName(0), node);
        }
        if (domainTable.size() == 1) {
            if (!toRejectAllConfigFiles) {
                locRes.addResult(singleDomainNodes, 1);
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("2011", false, (Object[])new String[]{"/etc/resolv.conf"}));
            }
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append(s_gMsgBundle.getMessage("2012", true, (Object[])new String[]{"/etc/resolv.conf"}) + LSEP);
            Enumeration<Object> e = domainTable.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String nodeListStr = VerificationUtil.strVect2List(domainTable.get(key));
                msg.append(s_gMsgBundle.getMessage("2013", false, (Object[])new String[]{key, nodeListStr}) + LSEP);
            }
            locRes.addResult(singleDomainNodes, 3);
            locRes.addErrorDescription(new ErrorDescription(msg.toString()));
            ReportUtil.sureprintln(msg.toString());
            status = false;
        }
        this.m_resultSet.uploadResultSet(locRes);
        return status;
    }

    public boolean performSearchOrderValidation() {
        ErrorDescription errDesc;
        ResultSet locRes = new ResultSet();
        boolean status = true;
        boolean toRejectAllConfigFiles = false;
        ReportUtil.println(s_msgBundle.getMessage("5621", false, (Object[])new String[]{"/etc/resolv.conf"}));
        ArrayList<String> searchExistNode = new ArrayList<String>();
        ArrayList<String> searchNonExistantNodes = new ArrayList<String>();
        for (String node : this.m_confOKVector) {
            if (this.m_allNodeResolvConf.get(node).isSearchOrderDefined()) {
                Trace.out((String)("search order exists on node :" + node));
                searchExistNode.add(node);
                continue;
            }
            Trace.out((String)("search order does not exist on node :" + node));
            searchNonExistantNodes.add(node);
        }
        if (searchExistNode.size() > 0 && searchNonExistantNodes.size() > 0) {
            String[] searchNonExistantArray = searchNonExistantNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5622", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(searchNonExistantNodes)});
            locRes.addResult(searchNonExistantArray, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            this.m_resultSet.uploadResultSet(locRes);
            status = false;
        } else {
            if (searchExistNode.size() == 0) {
                ReportUtil.println(s_gMsgBundle.getMessage("2004", false, (Object[])new String[]{"/etc/resolv.conf"}));
            }
            locRes.addResult(this.m_confOKVector.toArray(new String[0]), 1);
        }
        if (searchExistNode.size() == 0) {
            Trace.out((String)"search order name doesn't exist on any node");
            this.m_resultSet.uploadResultSet(locRes);
            return status;
        }
        ArrayList<String> singleSearchNodes = new ArrayList<String>();
        ArrayList<String> multiSearchNodes = new ArrayList<String>();
        ReportUtil.println(s_msgBundle.getMessage("5627", false, (Object[])new String[]{"/etc/resolv.conf"}));
        for (String node : searchExistNode) {
            int searchCount = this.m_allNodeResolvConf.get(node).getSearchOrderCount();
            Trace.out((String)("There are " + searchCount + " search order entries on " + node));
            if (searchCount > 1) {
                multiSearchNodes.add(node);
                continue;
            }
            singleSearchNodes.add(node);
            locRes.addResult(node, 1);
        }
        if (multiSearchNodes.size() > 0) {
            toRejectAllConfigFiles = true;
            String[] multiSearchArray = multiSearchNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5610", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(multiSearchNodes)});
            locRes.addResult(searchExistNode, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            ReportUtil.println(s_gMsgBundle.getMessage("2014", false, (Object[])new String[]{"/etc/resolv.conf"}));
        }
        if (singleSearchNodes.size() <= 1) {
            Trace.out((String)"no nodes with one search order");
            this.m_resultSet.uploadResultSet(locRes);
            return status;
        }
        Hashtable<Object, Vector<Object>> searchTable = new Hashtable<Object, Vector<Object>>();
        for (String node : singleSearchNodes) {
            VerificationUtil.updateResultMap(searchTable, this.m_allNodeResolvConf.get(node).getSearchOrder(0), node);
        }
        if (searchTable.size() == 1) {
            if (!toRejectAllConfigFiles) {
                locRes.addResult(singleSearchNodes, 1);
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("2009", false, (Object[])new String[]{"/etc/resolv.conf"}));
            }
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append(s_gMsgBundle.getMessage("2000", true, (Object[])new String[]{"/etc/resolv.conf"}) + LSEP);
            Enumeration<Object> e = searchTable.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String nodeListStr = VerificationUtil.strVect2List(searchTable.get(key));
                msg.append(s_gMsgBundle.getMessage("2001", false, (Object[])new String[]{key, nodeListStr}) + LSEP);
            }
            locRes.addResult(singleSearchNodes, 3);
            locRes.addErrorDescription(new ErrorDescription(msg.toString()));
            ReportUtil.sureprintln(msg.toString());
            status = false;
        }
        this.m_resultSet.uploadResultSet(locRes);
        return status;
    }

    public boolean performNameServerValidation() {
        boolean status = true;
        ReportUtil.println(s_msgBundle.getMessage("5611", false, (Object[])new String[]{"/etc/resolv.conf"}));
        ArrayList<String> nameServerExistNode = new ArrayList<String>();
        ArrayList<String> nameServerNonExistantNodes = new ArrayList<String>();
        for (String node : this.m_confOKVector) {
            if (this.m_allNodeResolvConf.get(node).isNameServerDefined()) {
                Trace.out((String)("name server exists on node :" + node));
                nameServerExistNode.add(node);
                continue;
            }
            Trace.out((String)("name server does not exist on node :" + node));
            nameServerNonExistantNodes.add(node);
        }
        if (nameServerExistNode.size() > 0 && nameServerNonExistantNodes.size() > 0) {
            String[] nameServerNonExistantArray = nameServerNonExistantNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5613", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(nameServerNonExistantNodes)});
            this.m_resultSet.addResult(nameServerNonExistantArray, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(nameServerNonExistantArray, errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5612", false, (Object[])new String[]{"/etc/resolv.conf"}));
            this.m_resultSet.addResult(this.m_confOKVector.toArray(new String[0]), 1);
        }
        if (nameServerExistNode.size() == 0) {
            Trace.out((String)"name server doesn't exist on any node");
            return status;
        }
        ArrayList<String> validNameServerNodes = new ArrayList<String>();
        ArrayList<String> invalidNameServerNodes = new ArrayList<String>();
        ReportUtil.println(s_msgBundle.getMessage("5630", false, (Object[])new String[]{"/etc/resolv.conf", Integer.toString(this.m_maxNS)}));
        for (String node : nameServerExistNode) {
            int nameServerCount = this.m_allNodeResolvConf.get(node).getNameServerCount();
            Trace.out((String)("There are " + nameServerCount + " name server entries on " + node));
            if (nameServerCount > this.m_maxNS) {
                invalidNameServerNodes.add(node);
                continue;
            }
            this.m_resultSet.addResult(node, 1);
            validNameServerNodes.add(node);
        }
        if (invalidNameServerNodes.size() > 0) {
            String[] invalidNameServerArray = invalidNameServerNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5607", true, (Object[])new String[]{"/etc/resolv.conf", Integer.toString(this.m_maxNS), VerificationUtil.strList2List(invalidNameServerNodes)});
            this.m_resultSet.addResult(invalidNameServerArray, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(invalidNameServerArray, errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5631", false, (Object[])new String[]{Integer.toString(this.m_maxNS), "/etc/resolv.conf"}));
        }
        if (validNameServerNodes.size() <= 1) {
            Trace.out((String)"no nodes with valid nameserver list");
            return status;
        }
        String refNode = (String)validNameServerNodes.get(0);
        List<String> refNameServerData = this.m_allNodeResolvConf.get(refNode).getNameServer();
        String refString = VerificationUtil.strCollection2String(refNameServerData, VerificationConstants.LSEP);
        Trace.out((String)("reference data" + refString));
        ReportUtil.sureprintln(s_msgBundle.getMessage("5617", false, (Object[])new String[]{refString, refNode}));
        ResultSet locRes = new ResultSet();
        for (String node : validNameServerNodes) {
            List<String> curNodeNameServerData = this.m_allNodeResolvConf.get(node).getNameServer();
            if (((Object)curNodeNameServerData).equals(refNameServerData)) {
                locRes.addResult(node, 1);
                continue;
            }
            String curString = VerificationUtil.strCollection2String(curNodeNameServerData, VerificationConstants.LSEP);
            Trace.out((String)("different search order :" + curString));
            String msg = s_msgBundle.getMessage("5614", true, (Object[])new String[]{"/etc/resolv.conf", node, curString});
            locRes.addResult(node, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        }
        this.m_resultSet.uploadResultSet(locRes);
        if (locRes.allSuccess()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5618", false));
        }
        return status;
    }

    public boolean performTimeOutRetryAttempsValidation() {
        ErrorDescription errDesc;
        int i;
        ArrayList<String> vffailedNodeList = new ArrayList<String>();
        ArrayList<String> opfailedNodeList = new ArrayList<String>();
        String[] confNodeList = this.m_confOKVector.toArray(new String[0]);
        ReportUtil.println(s_msgBundle.getMessage("5635", false, (Object[])new String[]{"/etc/resolv.conf"}));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8018", false));
        String unReachableNode = "unknown-not-reachable-node";
        VerificationCommand[] localDriverCmdArray = new VerificationCommand[confNodeList.length];
        for (i = 0; i < confNodeList.length; ++i) {
            Trace.out((String)("forming command for node:" + confNodeList[i]));
            String[] args = new String[]{"-rungencmd", this.m_nslookup, unReachableNode};
            String[] env = null;
            localDriverCmdArray[i] = new VerificationCommand(confNodeList[i], args, env);
        }
        for (i = 0; i < confNodeList.length; ++i) {
            String reportStatus = null;
            NslookupThread nsThread = new NslookupThread(localDriverCmdArray[i], confNodeList[i]);
            Trace.out((String)("executing on node" + confNodeList[i]));
            long startTime = System.currentTimeMillis();
            nsThread.run();
            long currentTime = System.currentTimeMillis();
            Trace.out((String)("currentTime = " + currentTime + " start time = " + startTime));
            if (currentTime - startTime > this.m_dnsAcceptableTime) {
                Trace.out((String)("currentTime=" + currentTime + "Start time =" + startTime));
                vffailedNodeList.add(confNodeList[i]);
                reportStatus = ReportUtil.FAILED;
                this.m_resultSet.addResult(confNodeList[i], 3);
                Trace.out((String)("Caught interrupted exception for node:" + confNodeList[i]));
            }
            if (reportStatus == null) {
                Trace.out((String)("thread not interrupted on node:" + confNodeList[i]));
                Result locRes = nsThread.getResult();
                if (locRes.getStatus() != 2) {
                    this.m_resultSet.addResult(confNodeList[i], 1);
                    reportStatus = ReportUtil.PASSED;
                } else {
                    Trace.out((String)("nslookup command didn't run on node:" + confNodeList[i]));
                    reportStatus = ReportUtil.FAILED;
                    opfailedNodeList.add(confNodeList[i]);
                    this.m_resultSet.addResult(confNodeList[i], 2);
                }
            }
            ReportUtil.writeRecord(confNodeList[i], reportStatus);
        }
        if (vffailedNodeList.size() != 0) {
            String msg = s_msgBundle.getMessage("5636", true, (Object[])new String[]{Long.toString(this.m_dnsAcceptableTime), VerificationUtil.strList2List(vffailedNodeList)});
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(vffailedNodeList.toArray(new String[0]), errDesc);
            ReportUtil.sureprintln(msg);
            return true;
        }
        if (opfailedNodeList.size() != 0) {
            String msg = s_msgBundle.getMessage("5637", true, (Object[])new String[]{VerificationUtil.strList2List(opfailedNodeList)});
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(opfailedNodeList.toArray(new String[0]), errDesc);
            ReportUtil.sureprintln(msg);
            return false;
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("5638", false));
        return true;
    }

    public boolean performSearchAndDomainCheck() {
        boolean status = true;
        ReportUtil.println(s_msgBundle.getMessage("5639", false, (Object[])new String[]{"/etc/resolv.conf"}));
        ArrayList<String> bothExistNodes = new ArrayList<String>();
        for (String node : this.m_confOKVector) {
            TaskResolvConfData taskData = this.m_allNodeResolvConf.get(node);
            if (!taskData.isDomainDefined() || !taskData.isSearchOrderDefined()) continue;
            Trace.out((String)("domain and search exists on node :" + node));
            bothExistNodes.add(node);
        }
        if (bothExistNodes.size() > 0) {
            String[] bothExistArray = bothExistNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5640", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(bothExistNodes)});
            this.m_resultSet.addResult(bothExistArray, 4);
            ReportUtil.printWarning(msg);
            for (String node : bothExistArray) {
                msg = s_gMsgBundle.getMessage("2016", true, (Object[])new String[]{"/etc/resolv.conf", node});
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(node, errDesc);
            }
            status = false;
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("2003", false, (Object[])new String[]{"/etc/resolv.conf"}));
            this.m_resultSet.addResult(this.m_confOKVector.toArray(new String[0]), 1);
        }
        return status;
    }

    private boolean prepareNodeResolvConfMap() {
        boolean status = true;
        String scratchPath = VerificationUtil.getCVUSubDirPath() + "scratch";
        File tempArea = new File(scratchPath);
        if (!tempArea.exists()) {
            tempArea.mkdirs();
        }
        if (!tempArea.isDirectory()) {
            tempArea.delete();
            tempArea.mkdir();
        }
        if (!tempArea.exists() || !tempArea.isDirectory()) {
            Trace.out((String)("Couldn't create " + tempArea.getName()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String msg = s_msgBundle.getMessage("5642", true, (Object[])new String[]{scratchPath});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            return false;
        }
        ArrayList<String> resolvConfnotExistNodes = new ArrayList<String>();
        ArrayList<String> resolvConfExistNodes = new ArrayList<String>();
        ClusterCmd clusterCmd = new ClusterCmd();
        for (String node : this.m_nodeList) {
            boolean copyStatus = false;
            Trace.out((String)("copying file from node:" + node));
            try {
                boolean currentNodeStatus = clusterCmd.fileExists(node, "/etc/resolv.conf");
                if (!currentNodeStatus) {
                    Trace.out((String)("resolv.conf does not exists on node" + node));
                    resolvConfnotExistNodes.add(node);
                    continue;
                }
                resolvConfExistNodes.add(node);
                copyStatus = clusterCmd.copyFileFromNode(node, "/etc/resolv.conf", scratchPath + "/resolv.conf_" + node);
                Trace.out((String)("copy status = " + copyStatus));
                if (!copyStatus) continue;
                this.m_confOKVector.add(node);
            }
            catch (ClusterException e) {
                Trace.out((String)"ClusterException while looking for resolv.conf");
                this.m_resultSet.addResult(node, 2);
                String msg = s_gMsgBundle.getMessage("2002", true, (Object[])new String[]{"/etc/resolv.conf", node, this.m_localHost}) + LSEP + e.getMessage();
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(msg));
                ReportUtil.sureprintln(msg);
                status = false;
            }
        }
        if (resolvConfnotExistNodes.size() > 0 && resolvConfExistNodes.size() > 0) {
            Trace.out((String)"resolv.conf exists on some nodes");
            String msg = s_msgBundle.getMessage("5605", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(resolvConfnotExistNodes)});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addResult(resolvConfnotExistNodes.toArray(new String[0]), 3);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(resolvConfExistNodes.toArray(new String[0]));
            ReportUtil.sureprintln("");
        } else if (resolvConfExistNodes.size() == 0) {
            Trace.out((String)"no resolv.conf on any node. not an error just skip the test");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5606", false, (Object[])new String[]{"/etc/resolv.conf"}));
            this.m_resultSet.addResult(this.m_nodeList, 1);
            this.m_resolvConfMissingAllNodes = true;
            return true;
        }
        if (this.m_confOKVector.size() == 0) {
            return false;
        }
        ArrayList<String> copyConfOKVector = new ArrayList<String>(this.m_confOKVector);
        for (String node : copyConfOKVector) {
            ErrorDescription errDesc;
            boolean badConfFile = false;
            ArrayList<String> badResolvConfLines = new ArrayList<String>();
            TaskResolvConfData curResolvConfData = new TaskResolvConfData();
            curResolvConfData.setNodeName(node);
            Trace.out((String)("Parsing resolv.conf of node:" + node));
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(scratchPath + "/resolv.conf_" + node));
                while ((line = in.readLine()) != null) {
                    String[] tokens;
                    if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    int index = line.indexOf("#");
                    if (index != -1) {
                        line = line.substring(0, index).trim();
                    }
                    if ((index = line.indexOf(";")) != -1) {
                        line = line.substring(0, index).trim();
                    }
                    if ((line = VerificationUtil.strArr2String(tokens = line.split("\\s+"), " ")).matches("^domain[\\s]+.*")) {
                        String[] domainArr = line.split("^domain[\\s]+");
                        if (domainArr.length != 2) {
                            badConfFile = true;
                            badResolvConfLines.add(line);
                            continue;
                        }
                        String domain = domainArr[1].trim();
                        Trace.out((String)("domain = " + domain));
                        if (domain != null && domain.length() != 0) {
                            curResolvConfData.setDomain(domain);
                            continue;
                        }
                        badConfFile = true;
                        badResolvConfLines.add(line);
                        continue;
                    }
                    if (line.matches("^search[\\s]+.*")) {
                        Trace.out((String)("search order line matched" + line));
                        String[] searchOrderArr = line.split("^search[\\s]+");
                        Trace.out((String)("search order length =" + searchOrderArr.length));
                        if (searchOrderArr.length != 2) {
                            badConfFile = true;
                            badResolvConfLines.add(line);
                            continue;
                        }
                        String searchOrder = searchOrderArr[1].trim();
                        Trace.out((String)("search order = " + searchOrder));
                        if (searchOrder != null && searchOrder.length() != 0) {
                            curResolvConfData.setSearchOrder(searchOrder);
                            continue;
                        }
                        badConfFile = true;
                        badResolvConfLines.add(line);
                        continue;
                    }
                    if (!line.matches("^nameserver[\\s]+.*")) continue;
                    String[] nameServerArr = line.split("^nameserver[\\s]+");
                    if (nameServerArr.length != 2) {
                        badConfFile = true;
                        badResolvConfLines.add(line);
                        continue;
                    }
                    String nameServer = nameServerArr[1].trim();
                    Trace.out((String)("name server = " + nameServer));
                    if (nameServer != null && nameServer.length() != 0) {
                        curResolvConfData.setNameServer(nameServer);
                        continue;
                    }
                    badConfFile = true;
                    badResolvConfLines.add(line);
                }
                if (!badConfFile) {
                    this.m_allNodeResolvConf.put(node, curResolvConfData);
                } else {
                    badResolvConfLines.add(0, node);
                    String msg = s_msgBundle.getMessage("5600", true, (Object[])new String[]{node, "/etc/resolv.conf", VerificationUtil.strCollection2String(badResolvConfLines, VerificationConstants.LSEP)});
                    errDesc = new ErrorDescription(msg);
                    this.m_resultSet.addErrorDescription(node, errDesc);
                    this.m_resultSet.addResult(node, 3);
                    ReportUtil.sureprintln(msg);
                    this.m_confOKVector.remove(node);
                    status = false;
                }
                in.close();
            }
            catch (IOException e) {
                Trace.out((String)("IOException while reading copied resolv.conf for node :" + node));
                this.m_resultSet.addResult(node, 2);
                String msg = s_msgBundle.getMessage("5629", true, (Object[])new String[]{"/etc/resolv.conf", node}) + VerificationConstants.LSEP + e.getMessage();
                errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(msg);
                this.m_confOKVector.remove(node);
                status = false;
            }
        }
        return status;
    }

    public String getResolvConfLocation() {
        return "/etc/resolv.conf";
    }

    private void cleanScratchDirectory(String scratchPath) {
        ArrayList<String> failedDeletes = new ArrayList<String>();
        for (String node : this.m_nodeList) {
            String tempLocation = scratchPath + "/resolv.conf_" + node;
            File resolvConf = new File(tempLocation);
            if (!resolvConf.exists() || resolvConf.delete()) continue;
            failedDeletes.add(tempLocation);
        }
        if (failedDeletes.size() > 0) {
            String msg = s_msgBundle.getMessage("5643", true, (Object[])new String[]{VerificationUtil.strList2List(failedDeletes)});
            ReportUtil.sureprintln(msg);
        }
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5632", false, (Object[])new String[]{"/etc/resolv.conf"});
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("5633", false);
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }
}

